/*!
\file CDGL_IDirect3D9.h
//! This file contains the declaration of the class CDGL_IDirect3D9. 
	This class is the concrete implementation of IDirect3D9 interface. The IDirect3D9 is made as an abstract class in d3d9.h (DXInclude)file.
\author Shilpa Prabhu
\version v1.0
\date 15Oct04
\copyright © 1994-2004 by Robosoft Technologies, all rights reserved.
\change history (most recent first)
\ <1>   15Oct04 Shilpa Prabhu Created file
*/

#ifndef __CDGL_IDIRECT3D9_H__
#define __CDGL_IDIRECT3D9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"
#include "DXGraphicsInit.h"


/*!
\class  CDGL_IDirect3D9
\brief  This class is the concrete implementation  of IDirect3D9 abstract class.
\detail Applications use the methods of the IDirect3D9 interface to create Microsoft® Direct3D® objects and set up the environment. 
		This interface includes methods for enumerating and retrieving capabilities of the device.
*/
class CDGL_IDirect3D9 : public IDirect3D9
{
	public:
		//! Constructor
		CDGL_IDirect3D9();
		//! Destructor
		~CDGL_IDirect3D9();
		
		//! IUnknown methods:
		
		//! Increments the reference count of this class.
		ULONG AddRef();
		//! Decrements the reference count of this class. If reference count becomes 0, releases all the allocated memory and deletes this class.
		ULONG Release();
		//! Determines whether the object supports a particular interface. If it does, the system increases the object's reference count, and the application can use that interface immediately.
		HRESULT QueryInterface(REFIID riid, void **ppvObj);
		
		//! IDirect3D9 methods:
		
		//! Determines whether a depth stencil format is compatible with a render target format in a particular display mode.
		HRESULT CheckDepthStencilMatch(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, D3DFORMAT RenderTargetFormat, D3DFORMAT DepthStencilFormat);
		//! Determines whether a surface format is available as a specified resource type and can be used as a texture, depth-stencil buffer, or render target, or any combination of the three, on a device representing this adapter.
		HRESULT CheckDeviceFormat(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapaterFormat, DWORD Usage, D3DRESOURCETYPE RType, D3DFORMAT CheckFormat);
		//! Tests the device to see if it supports conversion from one display format to another.
		HRESULT CheckDeviceFormatConversion(UINT Adapter,D3DDEVTYPE DeviceType,D3DFORMAT SourceFormat, D3DFORMAT TargetFormat);
		//! Determines if a multisampling technique is available on this device.
		HRESULT CheckDeviceMultiSampleType(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SurfaceFormat, BOOL Windowed, D3DMULTISAMPLE_TYPE MultiSampleType,DWORD* pQualityLevels);
		//! Verifies whether a hardware accelerated device type can be used on this adapter.
		HRESULT CheckDeviceType(UINT Adapter, D3DDEVTYPE CheckType, D3DFORMAT DisplayFormat, D3DFORMAT BackBufferFormat, BOOL Windowed);
		//! Creates a device to represent the display adapter. 
		HRESULT CreateDevice(UINT Adapter, D3DDEVTYPE DeviceType, HWND hFocusWindow, DWORD BehaviorFlags, D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DDevice9 **ppReturnedDeviceInterface);
		//! Enumerate the available adapter modes.
		HRESULT EnumAdapterModes(UINT Adapter,D3DFORMAT Format, UINT Mode, D3DDISPLAYMODE *pMode);
		//! Returns the number of adapters on the system.
		UINT	GetAdapterCount();
		//! Retrieves the current display mode of the adapter.
		HRESULT GetAdapterDisplayMode(UINT Adapter, D3DDISPLAYMODE *pMode);
		//! Describes the physical display adapters present in the system when the IDirect3D9 interface was instantiated.
		HRESULT GetAdapterIdentifier(UINT Adapter, DWORD Flags, D3DADAPTER_IDENTIFIER9 *pIdentifier);
		//! Returns the number of display modes available on this adapter.
		UINT	GetAdapterModeCount(UINT Adapter,D3DFORMAT Format);
		//! Returns the handle of the monitor associated with the Direct3D object.
		HMONITOR GetAdapterMonitor(UINT Adapter);
		//! Retrieves device-specific information about a device. 
		HRESULT GetDeviceCaps(UINT Adapter, D3DDEVTYPE DeviceType, D3DCAPS9 *pCaps);
		//! Registers a pluggable software device. Software devices provide software rasterization enabling applications to access a variety of software rasterizers.
		HRESULT RegisterSoftwareDevice(void *pInitializeFunction);
		
		//! Additional methods:
		
		//! This is an accessory function to return the structure pointer holding the context info and window pointer.
		GL_Driver_Information * GetGLDevice() { return m_pGlDevice; }
		//! Checks if a particular OpenGL extension is supported 
		bool IsExtSupported(eOGL_EXTS in_Ext) { return m_abExtensions[in_Ext]; } //Shilpa on 14 Apr 05
		//! To reset the device
		HRESULT Reset(IDirect3DDevice9* in_pDevice9, D3DPRESENT_PARAMETERS *pPresentationParameters);
		
	void	_initDeviceCaps();
	void	_initContextCaps();

		
	private:
		//! Member variables
		
		//! Holds the context information and window pointer(in windowed mode, NIL in fullscreen mode).
		GL_Driver_Information *	m_pGlDevice;
		//! Reference  counter to the object of this class.
		int						m_lRefCount;
		//! The event handler ref installed on the window 
		EventHandlerRef			m_EventHandlerRef;
		//! Booleans to indicate if any OpenGL extension is supported in the system or not.
		bool					m_abExtensions[ke_OGLEXTCount]; 
	
		IDirect3DDevice9		*mDevicePtr ; // sharathchandra 
		D3DCAPS9				mD3DDeviceCaps; // Sharathchandra 

		
};

#endif //__CDGL_IDIRECT3D9_H__

